'use strict';
/* Services */
angular.module('frontServicesResources', ['ngResource'])
    .factory('FrontCreatorStage', function($resource) {
        return $resource(appDev + '/front/rest/creator/getCreatorStage/:symbol',{}, {
            get: {
                method: "GET"
            }
        });
    })
    .factory('FrontCreatorUsersInGroupForLoggedUser', function($resource) {
        return $resource(appDev + '/front/rest/creator/getUsersInGroupForLoggedUser',{}, {
            get: {
                method: "GET"
                ,isArray:true
            }
        });
    })
    .factory('FrontCreatorCompanyForLoggedUser', function($resource) {
        return $resource(appDev + '/front/rest/creator/companyForLoggedUser',{}, {
            get: {
                method: "GET"
            }
            ,save: {
                method: "POST"
            }
        });
    })
    .factory('CompanyInventory', function($resource) {
        return $resource(appDev + '/front/rest/getCompanyInventory',{}, {
            get: {
                method: "GET"
            }
        });
    })
    .factory('FrontCreatorUserCompanyRoleTypes', function($resource) {
        return $resource(appDev + '/front/rest/creator/getUserCompanyRoleTypes',{}, {
            get: {
                method: "GET"
            }
        });
    })
    .factory('FrontCreatorCompanyConfirmStage', function($resource) {
        return $resource(appDev + '/front/rest/creator/companyConfirmStage',{}, {
            save: {
                method: "POST"
            }
        });
    })
    .factory('FrontCreatorPlaces', function($resource) {
        return $resource(appDev + '/front/rest/creator/places',{}, {
            getRandom: {
                method: "GET"
            }
            ,saveChecked: {
                method: "POST"
            }
        });
    })
    .factory('FrontCreatorChattel', function($resource) {
        return $resource(appDev + '/front/rest/creator/chattel',{}, {
            getRandomOffers: {
                method: "GET"
            }
            ,saveCheckedOffers: {
                method: "POST"
            }
        });
    })
    .factory('FrontCreatorBankServices', function($resource) {
        return $resource(appDev + '/front/rest/creator/bankServices',{}, {
            get: {
                method: "GET"
                ,isArray:true
            }
            ,saveOptions: {
                method: "POST"
            }
        });
    })
    .factory('FrontCreatorToken', function($resource) {
        return $resource(appDev + '/front/rest/creator/token/:users',{}, {
            get: {
                method: "GET"
            }
            ,save: {
                method: "POST"
            }
        });
    })
    .factory('FrontCreatorEmployee', function($resource) {
        return $resource(appDev + '/front/rest/creator/employees',{}, {
            get: {
                method: "GET"
                ,isArray:true
            }
        });
    })
    .factory('FrontCreatorDepartments', function($resource) {
        return $resource(appDev + '/front/rest/creator/departments',{}, {
            get: {
                method: "GET"
                ,isArray:true
            }
            ,save: {
                method: "POST"
            }
        });
    })
    .factory('FrontCreatorCodesPkd', function($resource) {
        return $resource(appDev + '/front/rest/creator/codesPkd',{}, {
            get: {
                method: "GET"
                ,isArray:true
            }
        });
    })
    .factory('FrontProductionCheckRestriction', function($resource) {
        return $resource(appDev + '/front/rest/checkRestrictions/:productionAmount',{}, {
            check: {
                method: "GET"
//                ,isArray:true
            }
        });
    })
    .factory('AdminFrontCurrency', function($resource) {
        return $resource(appDev + '/admin/api/currency',{}, {
            check: {
                method: "GET"
                ,isArray:true
            }
        });
    })
;